/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef JSDOMWindow_h
#define JSDOMWindow_h

#include "DOMWindow.h"
#include "JSDOMBinding.h"
#include "JSDOMWindowBase.h"
#include <runtime/JSObject.h>

namespace WebCore {

class DOMWindow;

class JSDOMWindowShell;

class JSDOMWindow : public JSDOMWindowBase {
public:
    typedef JSDOMWindowBase Base;
    static JSDOMWindow* create(JSC::VM& vm, JSC::Structure* structure, PassRefPtr<DOMWindow> impl, JSDOMWindowShell* windowShell)
    {
        JSDOMWindow* ptr = new (NotNull, JSC::allocateCell<JSDOMWindow>(vm.heap)) JSDOMWindow(vm, structure, impl, windowShell);
        ptr->finishCreation(vm, windowShell);
        vm.heap.addFinalizer(ptr, destroy);
        return ptr;
    }

    static const bool needsDestruction = false;

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static bool getOwnPropertySlotByIndex(JSC::JSCell*, JSC::ExecState*, unsigned propertyName, JSC::PropertySlot&);
    static void put(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::JSValue, JSC::PutPropertySlot&);
    static void putByIndex(JSC::JSCell*, JSC::ExecState*, unsigned propertyName, JSC::JSValue, bool shouldThrow);
    static const JSC::ClassInfo s_info;

    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::GlobalObjectType, StructureFlags), &s_info);
    }

    static bool deleteProperty(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName);
    static bool deletePropertyByIndex(JSC::JSCell*, JSC::ExecState*, unsigned);
    static void getPropertyNames(JSC::JSObject*, JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode mode = JSC::ExcludeDontEnumProperties);
    static void getOwnPropertyNames(JSC::JSObject*, JSC::ExecState*, JSC::PropertyNameArray&, JSC::EnumerationMode mode = JSC::ExcludeDontEnumProperties);
    static bool defineOwnProperty(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&, bool shouldThrow);
    static JSC::JSValue getConstructor(JSC::ExecState*, JSC::JSGlobalObject*);
    static void visitChildren(JSCell*, JSC::SlotVisitor&);


    // Custom attributes
    void setLocation(JSC::ExecState*, JSC::JSValue);
    JSC::JSValue event(JSC::ExecState*) const;
    JSC::JSValue image(JSC::ExecState*) const;

    // Custom functions
    JSC::JSValue open(JSC::ExecState*);
    JSC::JSValue showModalDialog(JSC::ExecState*);
    JSC::JSValue postMessage(JSC::ExecState*);
    JSC::JSValue setTimeout(JSC::ExecState*);
    JSC::JSValue setInterval(JSC::ExecState*);
    JSC::JSValue addEventListener(JSC::ExecState*);
    JSC::JSValue removeEventListener(JSC::ExecState*);
    DOMWindow* impl() const
    {
        return static_cast<DOMWindow*>(Base::impl());
    }
protected:
    JSDOMWindow(JSC::VM&, JSC::Structure*, PassRefPtr<DOMWindow>, JSDOMWindowShell*);
    static const unsigned StructureFlags = JSC::OverridesGetPropertyNames | JSC::ImplementsHasInstance | JSC::OverridesGetOwnPropertySlot | JSC::InterceptsGetOwnPropertySlotByIndexEvenWhenLengthIsNotZero | JSC::OverridesVisitChildren | JSC::HasImpureGetOwnPropertySlot | Base::StructureFlags;
};

DOMWindow* toDOMWindow(JSC::JSValue);

class JSDOMWindowPrototype : public JSC::JSNonFinalObject {
public:
    typedef JSC::JSNonFinalObject Base;
    static JSDOMWindowPrototype* create(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDOMWindowPrototype* ptr = new (NotNull, JSC::allocateCell<JSDOMWindowPrototype>(vm.heap)) JSDOMWindowPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    static const JSC::ClassInfo s_info;
    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }

private:
    JSDOMWindowPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure) : JSC::JSNonFinalObject(vm, structure) { }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::OverridesVisitChildren | Base::StructureFlags;
};

class JSDOMWindowConstructor : public DOMConstructorObject {
private:
    JSDOMWindowConstructor(JSC::Structure*, JSDOMGlobalObject*);
    void finishCreation(JSC::ExecState*, JSDOMGlobalObject*);

public:
    typedef DOMConstructorObject Base;
    static JSDOMWindowConstructor* create(JSC::ExecState* exec, JSC::Structure* structure, JSDOMGlobalObject* globalObject)
    {
        JSDOMWindowConstructor* ptr = new (NotNull, JSC::allocateCell<JSDOMWindowConstructor>(*exec->heap())) JSDOMWindowConstructor(structure, globalObject);
        ptr->finishCreation(exec, globalObject);
        return ptr;
    }

    static bool getOwnPropertySlot(JSC::JSCell*, JSC::ExecState*, JSC::PropertyName, JSC::PropertySlot&);
    static bool getOwnPropertyDescriptor(JSC::JSObject*, JSC::ExecState*, JSC::PropertyName, JSC::PropertyDescriptor&);
    static const JSC::ClassInfo s_info;
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), &s_info);
    }
protected:
    static const unsigned StructureFlags = JSC::OverridesGetOwnPropertySlot | JSC::ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

// Functions

JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetSelection(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionFocus(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionBlur(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClose(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPrint(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionStop(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionOpen(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionShowModalDialog(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAlert(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionConfirm(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPrompt(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionFind(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScrollBy(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScrollTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionScroll(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionMoveBy(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionMoveTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionResizeBy(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionResizeTo(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionMatchMedia(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetComputedStyle(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionGetMatchedCSSRules(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitConvertPointFromPageToNode(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitConvertPointFromNodeToPage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionPostMessage(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionSetTimeout(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClearTimeout(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionSetInterval(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionClearInterval(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionRequestAnimationFrame(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionCancelAnimationFrame(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitRequestAnimationFrame(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitCancelAnimationFrame(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitCancelRequestAnimationFrame(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAtob(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionBtoa(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionAddEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionRemoveEventListener(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionDispatchEvent(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionCaptureEvents(JSC::ExecState*);
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionReleaseEvents(JSC::ExecState*);
#if ENABLE(SQL_DATABASE)
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionOpenDatabase(JSC::ExecState*);
#endif
#if ENABLE(FILE_SYSTEM)
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitRequestFileSystem(JSC::ExecState*);
#endif
#if ENABLE(FILE_SYSTEM)
JSC::EncodedJSValue JSC_HOST_CALL jsDOMWindowPrototypeFunctionWebkitResolveLocalFileSystemURL(JSC::ExecState*);
#endif
// Attributes

JSC::JSValue jsDOMWindowScreen(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScreen(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHistory(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHistory(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowLocationbar(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowLocationbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMenubar(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMenubar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPersonalbar(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPersonalbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollbars(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScrollbars(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStatusbar(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowStatusbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowToolbar(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowToolbar(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNavigator(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNavigator(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientInformation(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowClientInformation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCrypto(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowLocation(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowLocation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEvent(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowEvent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFrameElement(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowOffscreenBuffering(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOffscreenBuffering(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOuterHeight(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOuterHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOuterWidth(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOuterWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInnerHeight(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowInnerHeight(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInnerWidth(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowInnerWidth(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenX(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScreenX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenY(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScreenY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenLeft(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScreenLeft(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScreenTop(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScreenTop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollX(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScrollX(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowScrollY(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScrollY(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPageXOffset(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowPageYOffset(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowClosed(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowLength(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowLength(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowName(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowName(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStatus(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDefaultStatus(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDefaultStatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDefaultstatus(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDefaultstatus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowSelf(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSelf(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWindow(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowFrames(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFrames(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOpener(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOpener(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowParent(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowParent(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTop(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowDocument(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowStyleMedia(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowDevicePixelRatio(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDevicePixelRatio(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowApplicationCache(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowSessionStorage(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowLocalStorage(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
JSC::JSValue jsDOMWindowConsole(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowConsole(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(CSS3_CONDITIONAL_RULES)
JSC::JSValue jsDOMWindowCSS(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSS(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowOnabort(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnabort(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnbeforeunload(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnbeforeunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnblur(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnblur(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncanplay(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOncanplay(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncanplaythrough(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOncanplaythrough(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnchange(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnclick(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOncontextmenu(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOncontextmenu(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndblclick(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndblclick(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndrag(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndrag(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragend(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndragend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragenter(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndragenter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragleave(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndragleave(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragover(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndragover(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndragstart(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndragstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndrop(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndrop(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOndurationchange(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndurationchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnemptied(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnemptied(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnended(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnended(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnerror(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnerror(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnfocus(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnfocus(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnhashchange(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnhashchange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOninput(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOninput(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOninvalid(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOninvalid(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeydown(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnkeydown(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeypress(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnkeypress(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnkeyup(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnkeyup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnload(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadeddata(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnloadeddata(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadedmetadata(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnloadedmetadata(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnloadstart(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnloadstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmessage(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmessage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousedown(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmousedown(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseenter(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmouseenter(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseleave(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmouseleave(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousemove(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmousemove(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseout(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmouseout(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseover(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmouseover(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmouseup(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmouseup(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnmousewheel(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnmousewheel(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnoffline(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnoffline(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnonline(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnonline(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpagehide(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnpagehide(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpageshow(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnpageshow(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpause(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnpause(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnplay(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnplay(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnplaying(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnplaying(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnpopstate(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnpopstate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnprogress(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnprogress(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnratechange(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnratechange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnresize(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnresize(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnscroll(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnscroll(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnseeked(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnseeked(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnseeking(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnseeking(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnselect(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnselect(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnstalled(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnstalled(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnstorage(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnstorage(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsubmit(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnsubmit(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsuspend(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnsuspend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntimeupdate(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOntimeupdate(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnunload(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnunload(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnvolumechange(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnvolumechange(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwaiting(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnwaiting(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnreset(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnreset(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnsearch(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnsearch(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationend(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnwebkitanimationend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationiteration(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnwebkitanimationiteration(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkitanimationstart(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnwebkitanimationstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOnwebkittransitionend(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnwebkittransitionend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOntransitionend(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOntransitionend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(TOUCH_EVENTS)
JSC::JSValue jsDOMWindowOntouchstart(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOntouchstart(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::JSValue jsDOMWindowOntouchmove(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOntouchmove(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::JSValue jsDOMWindowOntouchend(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOntouchend(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::JSValue jsDOMWindowOntouchcancel(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOntouchcancel(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(DEVICE_ORIENTATION)
JSC::JSValue jsDOMWindowOndevicemotion(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndevicemotion(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(DEVICE_ORIENTATION)
JSC::JSValue jsDOMWindowOndeviceorientation(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOndeviceorientation(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(PROXIMITY_EVENTS)
JSC::JSValue jsDOMWindowOnwebkitdeviceproximity(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOnwebkitdeviceproximity(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowImageConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowImageConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLDocumentConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(BLOB)
JSC::JSValue jsDOMWindowWebkitURLConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitURLConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowWebKitMutationObserverConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitMutationObserverConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIDBCursorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitIDBCursorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIDBDatabaseConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitIDBDatabaseConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIDBFactoryConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitIDBFactoryConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIDBIndexConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitIDBIndexConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIDBKeyRangeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitIDBKeyRangeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIDBObjectStoreConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitIDBObjectStoreConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIDBRequestConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitIDBRequestConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIDBTransactionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitIDBTransactionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowWebkitIndexedDB(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIndexedDB(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
#endif
#if ENABLE(QUOTA)
JSC::JSValue jsDOMWindowWebkitStorageInfo(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
JSC::JSValue jsDOMWindowWebKitMediaKeyMessageEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitMediaKeyMessageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
JSC::JSValue jsDOMWindowMediaKeyNeededEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMediaKeyNeededEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
JSC::JSValue jsDOMWindowWebKitMediaKeySessionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitMediaKeySessionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA_V2)
JSC::JSValue jsDOMWindowWebKitMediaKeysConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitMediaKeysConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBCursorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBCursorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBDatabaseConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBDatabaseConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBFactoryConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBFactoryConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBIndexConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBIndexConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBKeyRangeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBKeyRangeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBObjectStoreConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBObjectStoreConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBRequestConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBRequestConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBTransactionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBTransactionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(INDEXED_DATABASE)
JSC::JSValue jsDOMWindowIDBVersionChangeEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowIDBVersionChangeEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::JSValue jsDOMWindowWebKitMediaSourceConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitMediaSourceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::JSValue jsDOMWindowWebKitSourceBufferConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitSourceBufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(MEDIA_SOURCE)
JSC::JSValue jsDOMWindowWebKitSourceBufferListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitSourceBufferListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)
JSC::JSValue jsDOMWindowNotificationConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNotificationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SPEECH_SYNTHESIS)
JSC::JSValue jsDOMWindowSpeechSynthesisEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSpeechSynthesisEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SPEECH_SYNTHESIS)
JSC::JSValue jsDOMWindowSpeechSynthesisUtteranceConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSpeechSynthesisUtteranceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowAnalyserNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAnalyserNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowAudioBufferConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAudioBufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowAudioBufferSourceNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAudioBufferSourceNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowWebkitAudioContextConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitAudioContextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowAudioDestinationNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAudioDestinationNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowAudioListenerConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAudioListenerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowAudioNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAudioNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowAudioParamConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAudioParamConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowAudioProcessingEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAudioProcessingEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowBiquadFilterNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowBiquadFilterNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowChannelMergerNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowChannelMergerNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowChannelSplitterNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowChannelSplitterNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowConvolverNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowConvolverNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowDelayNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDelayNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowDynamicsCompressorNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDynamicsCompressorNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowGainNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowGainNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(VIDEO) && ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowMediaElementAudioSourceNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMediaElementAudioSourceNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(MEDIA_STREAM) && ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowMediaStreamAudioSourceNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMediaStreamAudioSourceNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowOfflineAudioCompletionEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOfflineAudioCompletionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowWebkitOfflineAudioContextConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitOfflineAudioContextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowOscillatorNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOscillatorNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowWebkitAudioPannerNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebkitAudioPannerNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowScriptProcessorNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScriptProcessorNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowWaveShaperNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWaveShaperNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_AUDIO)
JSC::JSValue jsDOMWindowWaveTableConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWaveTableConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SQL_DATABASE)
JSC::JSValue jsDOMWindowSQLExceptionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSQLExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowCloseEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCloseEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(WEB_SOCKETS)
JSC::JSValue jsDOMWindowWebSocketConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebSocketConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSCharsetRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSFontFaceRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(SHADOW_DOM)
JSC::JSValue jsDOMWindowCSSHostRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSHostRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowCSSImportRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSImportRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSMediaRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSPageRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSPageRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSPrimitiveValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSRuleListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSRuleListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSStyleDeclarationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSStyleRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSValueConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCSSValueListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCSSValueListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCounterConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCounterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMediaListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMediaListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRGBColorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowRGBColorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRectConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStyleSheetConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowStyleSheetConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStyleSheetListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowStyleSheetListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(CSS_SHADERS)
JSC::JSValue jsDOMWindowWebKitCSSFilterRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSFilterRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(CSS_FILTERS)
JSC::JSValue jsDOMWindowWebKitCSSFilterValueConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSFilterValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowWebKitCSSKeyframeRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSKeyframeRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSKeyframesRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSKeyframesRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitCSSMatrixConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSMatrixConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(CSS_SHADERS)
JSC::JSValue jsDOMWindowWebKitCSSMixFunctionValueConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSMixFunctionValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(CSS_REGIONS)
JSC::JSValue jsDOMWindowWebKitCSSRegionRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSRegionRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowWebKitCSSTransformValueConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSTransformValueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(CSS_DEVICE_ADAPTATION)
JSC::JSValue jsDOMWindowWebKitCSSViewportRuleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitCSSViewportRuleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowAttrConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAttrConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowBeforeLoadEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowBeforeLoadEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCDATASectionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCDATASectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCharacterDataConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCharacterDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientRectConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowClientRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClientRectListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowClientRectListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowClipboardConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowClipboardConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCommentConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCommentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCompositionEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCompositionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCustomEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCustomEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMExceptionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDOMExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMImplementationConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDOMImplementationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMStringListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDOMStringListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMStringMapConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDOMStringMapConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(DEVICE_ORIENTATION)
JSC::JSValue jsDOMWindowDeviceMotionEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDeviceMotionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(DEVICE_ORIENTATION)
JSC::JSValue jsDOMWindowDeviceOrientationEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDeviceOrientationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowDocumentConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocumentFragmentConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDocumentFragmentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDocumentTypeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDocumentTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEntityConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowEntityConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEntityReferenceConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowEntityReferenceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowErrorEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowErrorEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEventExceptionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowEventExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFocusEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFocusEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHashChangeEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHashChangeEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowKeyboardEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowKeyboardEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(CHANNEL_MESSAGING)
JSC::JSValue jsDOMWindowMessageChannelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMessageChannelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowMessageEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMessageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMessagePortConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMessagePortConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMouseEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMouseEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMutationEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMutationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMutationObserverConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMutationObserverConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMutationRecordConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMutationRecordConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNamedNodeMapConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNamedNodeMapConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNodeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeFilterConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNodeFilterConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeIteratorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNodeIteratorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNodeListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNodeListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNotationConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNotationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOverflowEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOverflowEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPageTransitionEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPageTransitionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPopStateEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPopStateEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowProcessingInstructionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowProcessingInstructionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowProgressEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowProgressEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(MICRODATA)
JSC::JSValue jsDOMWindowPropertyNodeListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPropertyNodeListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowRangeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowRangeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowRangeExceptionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowRangeExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(SHADOW_DOM)
JSC::JSValue jsDOMWindowWebKitShadowRootConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitShadowRootConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowTextConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTextEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTextEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(TOUCH_EVENTS)
JSC::JSValue jsDOMWindowTouchConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTouchConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::JSValue jsDOMWindowTouchEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTouchEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(TOUCH_EVENTS)
JSC::JSValue jsDOMWindowTouchListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTouchListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowTransitionEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTransitionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowTreeWalkerConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTreeWalkerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUIEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowUIEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitAnimationEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitAnimationEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWebKitTransitionEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitTransitionEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWheelEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWheelEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowBlobConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowBlobConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFileConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFileConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(BLOB) || ENABLE(FILE_SYSTEM)
JSC::JSValue jsDOMWindowFileErrorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFileErrorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowFileListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFileListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(BLOB)
JSC::JSValue jsDOMWindowFileReaderConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFileReaderConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowFormDataConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFormDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMSettableTokenListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDOMSettableTokenListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowDOMTokenListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDOMTokenListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(BLOB)
JSC::JSValue jsDOMWindowURLConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowURLConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLAllCollectionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLAllCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLAnchorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLAppletElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(VIDEO)
JSC::JSValue jsDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLAudioElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(VIDEO)
JSC::JSValue jsDOMWindowAudioConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowAudioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLBRElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLBRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLBaseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLBaseFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLBodyElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLButtonElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLCanvasElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLCollectionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDListElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLDListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(DATALIST_ELEMENT)
JSC::JSValue jsDOMWindowHTMLDataListElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLDataListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(DIALOG_ELEMENT)
JSC::JSValue jsDOMWindowHTMLDialogElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLDialogElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLDirectoryElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDivElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLDivElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLDocumentConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLEmbedElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLFieldSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFontElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFormControlsCollectionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLFormControlsCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFormElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLFormElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLFrameSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHRElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLHRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLHeadElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLHeadingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLHtmlElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLIFrameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLImageElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLInputElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLInputElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLKeygenElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLKeygenElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLIElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLLIElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLLabelElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLLegendElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLLinkElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMapElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLMapElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLMarqueeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(VIDEO)
JSC::JSValue jsDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLMediaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLMenuElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLMetaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(METER_ELEMENT)
JSC::JSValue jsDOMWindowHTMLMeterElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLMeterElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLModElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLModElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOListElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLOListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLObjectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLOptGroupElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLOptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowOptionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowOptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOptionsCollectionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLOptionsCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLOutputElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLOutputElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLParagraphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLParamElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLParamElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLPreElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLPreElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(PROGRESS_ELEMENT)
JSC::JSValue jsDOMWindowHTMLProgressElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLProgressElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(MICRODATA)
JSC::JSValue jsDOMWindowHTMLPropertiesCollectionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLPropertiesCollectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLQuoteElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLScriptElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLSelectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(VIDEO)
JSC::JSValue jsDOMWindowHTMLSourceElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLSourceElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLSpanElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLSpanElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLStyleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTableCaptionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTableCellElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTableColElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTableElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTableRowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTableSectionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(TEMPLATE_ELEMENT)
JSC::JSValue jsDOMWindowHTMLTemplateElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTemplateElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTextAreaElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTitleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(VIDEO_TRACK)
JSC::JSValue jsDOMWindowHTMLTrackElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLTrackElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowHTMLUListElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLUListElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHTMLUnknownElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLUnknownElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(VIDEO)
JSC::JSValue jsDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLVideoElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowImageDataConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowImageDataConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(VIDEO)
JSC::JSValue jsDOMWindowMediaControllerConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMediaControllerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(VIDEO)
JSC::JSValue jsDOMWindowMediaErrorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMediaErrorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA_V2)
JSC::JSValue jsDOMWindowWebKitMediaKeyErrorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitMediaKeyErrorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(ENCRYPTED_MEDIA)
JSC::JSValue jsDOMWindowMediaKeyEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMediaKeyEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowTextMetricsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTextMetricsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(VIDEO)
JSC::JSValue jsDOMWindowTimeRangesConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTimeRangesConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowArrayBufferConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowArrayBufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowArrayBufferViewConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowArrayBufferViewConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCanvasGradientConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCanvasGradientConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowCanvasPatternConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCanvasPatternConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(CANVAS_PROXY)
JSC::JSValue jsDOMWindowCanvasProxyConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCanvasProxyConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowCanvasRenderingContext2DConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(CANVAS_PATH)
JSC::JSValue jsDOMWindowPathConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPathConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowDataViewConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDataViewConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFloat32ArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFloat32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowFloat64ArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowFloat64ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInt16ArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowInt16ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInt32ArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowInt32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowInt8ArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowInt8ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUint16ArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowUint16ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUint32ArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowUint32ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUint8ArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowUint8ArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowUint8ClampedArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowUint8ClampedArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLActiveInfoConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLActiveInfoConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLBufferConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLBufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLContextEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLContextEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLFramebufferConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLFramebufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLProgramConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLProgramConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLRenderbufferConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLRenderbufferConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLRenderingContextConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLRenderingContextConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLShaderConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLShaderConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLShaderPrecisionFormatConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLShaderPrecisionFormatConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLTextureConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLTextureConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEBGL)
JSC::JSValue jsDOMWindowWebGLUniformLocationConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebGLUniformLocationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SHADOW_DOM)
JSC::JSValue jsDOMWindowHTMLContentElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHTMLContentElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::JSValue jsDOMWindowTextTrackConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTextTrackConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::JSValue jsDOMWindowTextTrackCueConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTextTrackCueConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::JSValue jsDOMWindowTextTrackCueListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTextTrackCueListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::JSValue jsDOMWindowTextTrackListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTextTrackListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(VIDEO_TRACK)
JSC::JSValue jsDOMWindowTrackEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowTrackEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowBarPropConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowBarPropConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(CSP_NEXT)
JSC::JSValue jsDOMWindowSecurityPolicyConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSecurityPolicyConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowSelectionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSelectionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowWindowConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWindowConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowEventSourceConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowEventSourceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowHistoryConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowHistoryConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowLocationConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowLocationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowNavigatorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowNavigatorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(WEB_TIMING)
JSC::JSValue jsDOMWindowPerformanceConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPerformanceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_TIMING)
JSC::JSValue jsDOMWindowPerformanceNavigationConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPerformanceNavigationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WEB_TIMING)
JSC::JSValue jsDOMWindowPerformanceTimingConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPerformanceTimingConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowScreenConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowScreenConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(INPUT_SPEECH)
JSC::JSValue jsDOMWindowSpeechInputEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSpeechInputEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowWebKitPointConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWebKitPointConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMimeTypeConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMimeTypeConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowMimeTypeArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPluginConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPluginConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowPluginArrayConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowPluginArrayConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStorageConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowStorageConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowStorageEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowStorageEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGAltGlyphDefElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAltGlyphDefElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGAltGlyphElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAltGlyphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGAltGlyphItemElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAltGlyphItemElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAngleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAngleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimateColorElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimateColorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimateElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimateElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimateMotionElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimateMotionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimateTransformElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimateTransformElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedAngleConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedAngleConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedBooleanConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedBooleanConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedEnumerationConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedEnumerationConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedIntegerConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedIntegerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedLengthConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedLengthConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedLengthListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedLengthListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedNumberConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedNumberConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedNumberListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedNumberListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedRectConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedStringConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedStringConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGAnimatedTransformListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGAnimatedTransformListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGCircleElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGCircleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGClipPathElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGClipPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGColorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGColorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGComponentTransferFunctionElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGComponentTransferFunctionElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGCursorElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGCursorElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGDefsElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGDefsElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGDescElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGDescElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGDocumentConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGDocumentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGElementInstanceConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGElementInstanceConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGElementInstanceListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGElementInstanceListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGEllipseElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGEllipseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGExceptionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEBlendElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEBlendElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEColorMatrixElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEColorMatrixElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEComponentTransferElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEComponentTransferElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFECompositeElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFECompositeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEConvolveMatrixElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEConvolveMatrixElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEDiffuseLightingElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEDiffuseLightingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEDisplacementMapElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEDisplacementMapElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEDistantLightElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEDistantLightElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEDropShadowElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEDropShadowElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEFloodElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEFloodElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEFuncAElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEFuncAElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEFuncBElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEFuncBElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEFuncGElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEFuncGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEFuncRElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEFuncRElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEGaussianBlurElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEGaussianBlurElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEImageElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEMergeElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEMergeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEMergeNodeElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEMergeNodeElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEMorphologyElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEMorphologyElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEOffsetElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEOffsetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFEPointLightElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFEPointLightElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFESpecularLightingElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFESpecularLightingElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFESpotLightElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFESpotLightElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFETileElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFETileElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFETurbulenceElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFETurbulenceElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(FILTERS) && ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGFilterElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFilterElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGFontElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFontElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGFontFaceElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFontFaceElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGFontFaceFormatElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFontFaceFormatElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGFontFaceNameElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFontFaceNameElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGFontFaceSrcElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFontFaceSrcElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGFontFaceUriElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGFontFaceUriElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGForeignObjectElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGForeignObjectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGGElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGGlyphElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGGlyphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGGlyphRefElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGGlyphRefElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGGradientElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGHKernElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGHKernElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGImageElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGImageElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGLengthConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGLengthConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGLengthListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGLengthListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGLineElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGLineElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGLinearGradientElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGLinearGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGMPathElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGMPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGMarkerElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGMaskElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGMaskElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGMatrixConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGMatrixConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGMetadataElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGMetadataElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGMissingGlyphElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGMissingGlyphElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGNumberConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGNumberConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGNumberListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGNumberListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPaintConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPaintConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegArcAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegArcAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegArcRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegArcRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegClosePathConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegClosePathConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegCurvetoCubicAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegCurvetoCubicRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegCurvetoCubicSmoothAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegCurvetoCubicSmoothRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegCurvetoQuadraticAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegCurvetoQuadraticRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegCurvetoQuadraticSmoothRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegLinetoAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegLinetoAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegLinetoHorizontalAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegLinetoHorizontalAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegLinetoHorizontalRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegLinetoHorizontalRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegLinetoRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegLinetoRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegLinetoVerticalAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegLinetoVerticalAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegLinetoVerticalRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegLinetoVerticalRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegMovetoAbsConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegMovetoAbsConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPathSegMovetoRelConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPathSegMovetoRelConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPatternElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPatternElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPointConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPointConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPointListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPointListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPolygonElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPolygonElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPolylineElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPolylineElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGPreserveAspectRatioConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGRadialGradientElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGRadialGradientElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGRectConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGRectConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGRectElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGRectElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGRenderingIntentConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGSVGElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGSVGElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGScriptElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGScriptElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGSetElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGSetElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGStopElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGStopElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGStringListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGStringListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGStyleElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGStyleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGSwitchElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGSwitchElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGSymbolElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGSymbolElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTRefElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTRefElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTSpanElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTSpanElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTextContentElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTextElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTextElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTextPathElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTextPositioningElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTextPositioningElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTitleElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTitleElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTransformConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTransformConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGTransformListConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGTransformListConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGUnitTypesConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGUseElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGUseElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG) && ENABLE(SVG_FONTS)
JSC::JSValue jsDOMWindowSVGVKernElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGVKernElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGViewElementConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGViewElementConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGViewSpecConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGViewSpecConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGZoomAndPanConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGZoomAndPanConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SVG)
JSC::JSValue jsDOMWindowSVGZoomEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSVGZoomEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SHARED_WORKERS)
JSC::JSValue jsDOMWindowSharedWorkerConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowSharedWorkerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(WORKERS)
JSC::JSValue jsDOMWindowWorkerConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowWorkerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
JSC::JSValue jsDOMWindowDOMParserConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowDOMParserConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXMLHttpRequestConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXMLHttpRequestExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestProgressEventConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXMLHttpRequestProgressEventConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXMLHttpRequestUploadConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXMLSerializerConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXMLSerializerConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXPathEvaluatorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXPathEvaluatorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXPathExceptionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXPathExceptionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXPathExpressionConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXPathExpressionConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
JSC::JSValue jsDOMWindowXPathResultConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXPathResultConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#if ENABLE(XSLT)
JSC::JSValue jsDOMWindowXSLTProcessorConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowXSLTProcessorConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
#endif
#if ENABLE(SPEECH_SYNTHESIS)
JSC::JSValue jsDOMWindowSpeechSynthesis(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
#endif
#if ENABLE(LEGACY_NOTIFICATIONS) || ENABLE(NOTIFICATIONS)
JSC::JSValue jsDOMWindowWebkitNotifications(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
#endif
JSC::JSValue jsDOMWindowConstructor(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
void setJSDOMWindowConstructor(JSC::ExecState*, JSC::JSObject*, JSC::JSValue);
// Constants

#if ENABLE(FILE_SYSTEM)
JSC::JSValue jsDOMWindowTEMPORARY(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
#endif
#if ENABLE(FILE_SYSTEM)
JSC::JSValue jsDOMWindowPERSISTENT(JSC::ExecState*, JSC::JSValue, JSC::PropertyName);
#endif

} // namespace WebCore

#endif
